// 💥 Сделай эту функцию глобальной
function openModal(src) {
  const modal = document.getElementById("img-modal");
  const modalImg = document.getElementById("img-modal-src");
  modal.style.display = "block";
  modalImg.src = src;
}

// 🌐 Глобальная переменная BASE_URL (будет установлена позже)
let BASE_URL = "";

// 📦 Остальной код после получения BASE_URL
document.addEventListener("DOMContentLoaded", () => {
  new QWebChannel(qt.webChannelTransport, function (channel) {
    const bridge = channel.objects.bridge;

    // 📡 Получаем BASE_URL из Python
	bridge.get_base_url(function(url) {
	BASE_URL = url;
	initializeAdminPanel(bridge);
	});
  });
});

function initializeAdminPanel(bridge) {
    const tabs = document.querySelectorAll(".admincp-tabs button");
    const content = document.getElementById("admincp-content");

    const tabData = {
      donate: "<h2>Donate</h2><p>All donation transactions will be listed here.</p>",
      characters: "<h2>All Characters</h2><p>Manage all players: ban, give WCoinC/WCoinP/GP.</p>",
      guilds: "<h2>Guilds</h2><p>Manage guilds: edit, delete, change masters.</p>",
      logs: "<h2>Logs</h2><p>Review player login and action logs.</p>",
      hwid: "<h2>HWID Tracker</h2><p>Show all HWID logs and account mapping.</p>",
      ipban: "<h2>IP Ban / Unban</h2><p>List of banned IPs, tools for IP blocking.</p>",
      promocodes: "<h2>Promo Codes</h2><p>Create and manage promotional codes.</p>"
    };

    let currentPage = 1;
    const rowsPerPage = 6;

    async function loadAntiCheatData() {
      return new Promise((resolve) => {
        bridge.get_blacklist_json(function (raw) {
          try {
            const data = JSON.parse(raw);
            const sortedKeys = Object.keys(data).sort((a, b) => data[b].banned_until - data[a].banned_until);
    
            const container = document.createElement("div");
			container.innerHTML = `
			<h2>Anticheat — Banned Users</h2>
			<input type="text" placeholder="🔍 Search by nickname or HWID..." class="character-search" style="margin-bottom: 10px; padding: 6px 12px; width: 300px;">
			`;

            const table = document.createElement("table");
            table.className = "anticheat-table";
            table.innerHTML = `
              <thead>
                <tr>
                  <th>HWID</th>
                  <th>IP Address</th>
                  <th>Attempts</th>
                  <th>Banned Until</th>
                  <th>Unban</th>
                </tr>
              </thead>
              <tbody></tbody>
            `;
    
            const tbody = table.querySelector("tbody");
    
            sortedKeys.forEach((hwid) => {
              const entry = data[hwid];
              const isExpired = Date.now() > entry.banned_until * 1000;
              const bannedUntilStr = new Date(entry.banned_until * 1000).toLocaleString();
    
              const tr = document.createElement("tr");
              tr.classList.add("page-row");
              tr.style.cursor = "pointer";
              tr.innerHTML = `
                <td>${hwid}</td>
                <td>${entry.ip}</td>
                <td>${entry.attempts}</td>
                <td>
                  <span class="${isExpired ? 'ban-expired' : 'ban-active'}">${bannedUntilStr}</span>
                </td>
                <td>
                  ${!isExpired ? `<button class="unban-btn" data-hwid="${hwid}">Unban</button>` : ""}
                </td>
              `;
    
              const detailsRow = document.createElement("tr");
              detailsRow.className = "detail-row";
              detailsRow.style.display = "none";
              detailsRow.innerHTML = `
                <td colspan="5" style="padding: 0px">
                  <div class="detail-container">
                    <div style="display: flex; justify-content: space-between; align-items: flex-start;">
                      <div style="flex: 1;">
                        <div class="detail-row-flex">
                          <p><strong>Nicknames:</strong> ${entry.nicknames?.join(", ") || "-"}</p>
                          <p class="reason-process" style="margin-right: 20px;"><strong>Reason:</strong> ${entry.ban_reason || "-"}</p>
                        </div>
                        <div class="detail-row-flex">
                          <p><strong>Detected At:</strong> ${entry.detected_at || "-"}</p>
                          <p class="reason-process" style="margin-right: 20px;"><strong>Process:</strong> ${entry.process_name || "-"}</p>
                        </div>
                        <p><strong>Hash:</strong> ${entry.detected_hash || "-"}</p>
                      </div>
                      ${entry.screenshot_file
                        ? `<img src="${BASE_URL}AntiCheat/screenshots/${entry.screenshot_file}" class="screenshot-preview" onclick="openModal(this.src)" />`
                        : ""}
                    </div>
                  </div>
                </td>
              `;
    
              tr.addEventListener("click", () => {
                const allDetails = table.querySelectorAll("tr.detail-row");
                const isOpen = detailsRow.style.display === "table-row";
                allDetails.forEach(row => row.style.display = "none");
                table.querySelectorAll("tr.page-row").forEach(row => row.style.display = "table-row");
                if (!isOpen) {
                  detailsRow.style.display = "table-row";
                  table.querySelectorAll("tr.page-row").forEach(row => row.style.display = "none");
                  tr.style.display = "table-row";
                }
              });
    
              tbody.appendChild(tr);
              tbody.appendChild(detailsRow);
            });
    
            function bindUnbanButtons() {
              document.querySelectorAll(".unban-btn").forEach(btn => {
                btn.addEventListener("click", () => {
                  const hwid = btn.dataset.hwid;
                  if (confirm(`Unban HWID ${hwid}?`)) {
                    fetch("unban.php", {
                      method: "POST",
                      headers: { "Content-Type": "application/x-www-form-urlencoded" },
                      body: `hwid=${encodeURIComponent(hwid)}`
                    }).then(() => {
                      loadAntiCheatData().then(view => {
                        const content = document.getElementById("admincp-content");
                        content.innerHTML = "";
                        content.appendChild(view);
                      });
                    });
                  }
                });
              });
            }
    
            const wrapper = document.createElement("div");
            wrapper.className = "donate-table-container character-scroll"; // кастомный скролл
            wrapper.appendChild(table);
            container.appendChild(wrapper);
    
            bindUnbanButtons();
			
            // 🔍 Фильтрация по HWID, Nicknames и IP
            const searchInput = container.querySelector(".character-search");
            searchInput.addEventListener("input", () => {
              const value = searchInput.value.toLowerCase();
              const allRows = Array.from(table.querySelectorAll("tr.page-row"));
              const allDetails = Array.from(table.querySelectorAll("tr.detail-row"));
            
              allRows.forEach((row, i) => {
                const detailRow = allDetails[i];
                const hwid = row.cells[0].textContent.toLowerCase();
                const ip = row.cells[1].textContent.toLowerCase();
                const nickText = detailRow?.innerText?.toLowerCase() || "";
            
                const match = hwid.includes(value) || ip.includes(value) || nickText.includes(value);
            
                if (match) {
                  row.style.display = "table-row";
                  detailRow.style.display = "table-row"; // раскрываем
                } else {
                  row.style.display = "none";
                  detailRow.style.display = "none";
                }
              });
            
              // 👉 Если строка поиска очищена — свернуть все detail-строки
              if (!value) {
                allDetails.forEach(row => row.style.display = "none");
              }
            });

            resolve(container);
          } catch (e) {
            const error = document.createElement("p");
            error.textContent = "❌ Failed to parse blacklist data.";
            resolve(error);
          }
        });
      });
    }
    
    async function loadCharacters() {
      return new Promise(async (resolve) => {
        try {
          console.log("📥 Fetching characters-cache.json...");
          const rawChars = await new Promise(res => bridge.get_characters_cache(res));
          const data = JSON.parse(rawChars);
    
          console.log("📥 Fetching memb_stat.json...");
          const rawOnline = await new Promise(res => bridge.get_online_json(res));
          const onlineList = JSON.parse(rawOnline); // ключи — AccountID
    
          console.log("📥 Fetching cashshopdata.json...");
          const rawCoins = await new Promise(res => bridge.get_cashshop_data(res));
          const cashshopdata = JSON.parse(rawCoins); // ключи — AccountID
    
          const container = document.createElement("div");
          container.innerHTML = `<h2>All Characters</h2>`;
    
          // 🔍 Search input
          const search = document.createElement("input");
          search.placeholder = "🔍 Search by character name...";
          search.className = "character-search";
          search.style = "margin-bottom: 10px; padding: 6px 12px; width: 300px;";
          container.appendChild(search);
    
          const table = document.createElement("table");
          table.className = "donate-table";
          table.innerHTML = `
            <thead>
              <tr>
                <th>Character</th>
                <th>Status</th>
                <th>WCoinC</th>
                <th>WCoinP</th>
                <th>GP</th>
                <th>Screenshot</th>
                <th>Ban / Unban</th>
                <th>Add Coins</th>
              </tr>
            </thead>
            <tbody></tbody>
          `;
    
          const tbody = table.querySelector("tbody");
          const allRows = [];
          const detailsRows = [];
          
          Object.values(data).forEach(char => {
            const isOnline = onlineList[char.AccountID]?.ConnectStat === 1;
            const accountCoins = cashshopdata[char.AccountID] || {};
          
            const tr = document.createElement("tr");
            tr.innerHTML = `
              <td>${char.Name}</td>
              <td style="color:${isOnline ? '#0f0' : '#f55'}">${isOnline ? "Online" : "Offline"}</td>
              <td>${accountCoins.WCoinC ?? 0}</td>
              <td>${accountCoins.WCoinP ?? 0}</td>
              <td>${accountCoins.GoblinPoint ?? 0}</td>
              <td><button class="btn-screenshot" data-char="${char.Name}">📸</button></td>
              <td><button class="btn-ban-toggle" data-char="${char.Name}" data-banned="${char.Banned ? 1 : 0}">
                  ${char.Banned ? "Unban" : "Ban"}
              </button></td>
              <td>
                <button class="btn-add-coins" data-char="${char.Name}" data-type="WCoinC">WC</button>
                <button class="btn-add-coins" data-char="${char.Name}" data-type="WCoinP">WP</button>
                <button class="btn-add-coins" data-char="${char.Name}" data-type="GP">GP</button>
              </td>
            `;
            tbody.appendChild(tr);
          
            const detailsRow = document.createElement("tr");
            detailsRow.className = "detail-row";
            detailsRow.style.display = "none";
            detailsRow.innerHTML = `
              <td colspan="8" style="padding: 0px;">
                <div class="detail-container">
                  <div class="detail-row-flex">
                    <p><strong>Screenshots for:</strong> ${char.Name}</p>
                    <div class="screenshot-list" id="screens-${char.Name}" style="display:flex; gap:10px; flex-wrap:wrap;"></div>
                  </div>
                </div>
              </td>
            `;
            tbody.appendChild(detailsRow);
          
            // Добавляем в массивы в порядке: обычная строка и её detail
            allRows.push(tr);
            detailsRows.push(detailsRow);
            
            // 📂 РАСКРЫТИЕ строки при клике
            tr.addEventListener("click", () => {
              const isOpen = detailsRow.style.display === "table-row";
              table.querySelectorAll("tr.detail-row").forEach(row => row.style.display = "none");
              table.querySelectorAll("tr").forEach(row => row.classList.remove("selected"));
              if (!isOpen) {
                detailsRow.style.display = "table-row";
                tr.classList.add("selected");
            
                // Загрузка скриншотов
                fetch(`${BASE_URL}AntiCheat/screenshots_admin/list.php?char=${char.Name}`)
                  .then(res => res.json())
                  .then(files => {
                    const container = detailsRow.querySelector(`#screens-${char.Name}`);
                    container.innerHTML = "";
                    if (files.length === 0) {
                      container.innerHTML = "<p style='color:#aaa;'>No screenshots found</p>";
                    } else {
                      files.forEach(file => {
                        const imgWrapper = document.createElement("div");
                        imgWrapper.style.position = "relative";
                        imgWrapper.style.display = "inline-block";
            
                        const img = document.createElement("img");
                        img.src = `${BASE_URL}AntiCheat/screenshots_admin/${file}`;
                        img.className = "screenshot-preview";
                        img.style.cursor = "zoom-in";
                        img.onclick = () => openModal(img.src);
            
                        // Кнопка удаления
                        const delBtn = document.createElement("button");
                        delBtn.textContent = "×";
                        delBtn.title = "Delete screenshot";
                        delBtn.style.position = "absolute";
                        delBtn.style.top = "2px";
                        delBtn.style.right = "2px";
                        delBtn.style.background = "rgba(255, 0, 0, 0.7)";
                        delBtn.style.color = "white";
                        delBtn.style.border = "none";
                        delBtn.style.borderRadius = "50%";
                        delBtn.style.width = "20px";
                        delBtn.style.height = "20px";
                        delBtn.style.cursor = "pointer";
                        delBtn.style.fontWeight = "bold";
                        delBtn.style.lineHeight = "18px";
                        delBtn.style.textAlign = "center";
                        delBtn.style.padding = "0";
            
                        delBtn.onclick = (e) => {
                          e.stopPropagation(); // чтобы не открывалась полноразмерная картинка
                          if (confirm(`Delete screenshot "${file}"?`)) {
                            fetch(`${BASE_URL}AntiCheat/screenshots_admin/delete.php`, {
                              method: "POST",
                              headers: { "Content-Type": "application/x-www-form-urlencoded" },
                              body: `char=${encodeURIComponent(char.Name)}&file=${encodeURIComponent(file)}`
                            })
                            .then(res => res.json())
                            .then(data => {
                              if (data.success) {
                                imgWrapper.remove();
                                alert("Screenshot deleted");
                              } else {
                                alert(`Failed to delete screenshot: ${data.error || 'Unknown error'}`);
                              }
                            })
                            .catch(() => {
                              alert("Failed to delete screenshot: network error");
                            });
                          }
                        };
                        
                        imgWrapper.appendChild(img);
                        imgWrapper.appendChild(delBtn);
                        container.appendChild(imgWrapper);
                      });
                    }
                  });
              } else {
                detailsRow.style.display = "none";
                tr.classList.remove("selected");
              }
            });

            allRows.push(tr);
          });
    
		  const wrapper = document.createElement("div");
		  wrapper.className = "donate-table-container character-scroll";
		  wrapper.appendChild(table);
		  container.appendChild(wrapper); 
		  
          // 🔍 Фильтрация
          search.addEventListener("input", () => {
            const filter = search.value.toLowerCase();
            allRows.forEach((row, i) => {
              const name = row.querySelector("td")?.textContent.toLowerCase() || "";
              const detailsRow = detailsRows[i];
              if (name.includes(filter)) {
                row.style.display = "";
              } else {
                row.style.display = "none";
                if (detailsRow) {
                  detailsRow.style.display = "none"; // всегда скрываем detail при фильтрации
                  row.classList.remove("selected");
                }
              }
            });
          
            if (!filter) {
              detailsRows.forEach((dr, i) => {
                dr.style.display = "none";
                allRows[i].classList.remove("selected");
              });
            }
          });

          // 📸 Screenshot handler
          table.querySelectorAll(".btn-screenshot").forEach(btn => {
            btn.onclick = () => {
              const name = btn.dataset.char;
				bridge.request_player_screenshot(name);
				alert(`📸 Screenshot request sent to ${name}`);
            };
          });
    
          // 🚫 Ban / Unban handler
          table.querySelectorAll(".btn-ban-toggle").forEach(btn => {
            btn.onclick = () => {
              const name = btn.dataset.char;
              const isBanned = btn.dataset.banned === "1";
              bridge.toggle_ban(name, !isBanned);
              btn.textContent = isBanned ? "Ban" : "Unban";
              btn.dataset.banned = isBanned ? "0" : "1";
            };
          });
    
          // 💰 Add Coins handler
          table.querySelectorAll(".btn-add-coins").forEach(btn => {
            btn.onclick = () => {
              const name = btn.dataset.char;
              const type = btn.dataset.type;
              const value = prompt(`Enter amount to add to ${name} (${type}):`);
              const amount = parseInt(value);
              if (!isNaN(amount) && amount > 0) {
                bridge.add_coins(name, type, amount);
                alert(`✅ Added ${amount} ${type} to ${name}`);
              }
            };
          });
    
          resolve(container);
        } catch (e) {
          console.error("❌ Failed to load characters:", e);
          const error = document.createElement("p");
          error.textContent = "❌ Failed to load characters.";
          resolve(error);
        }
      });
    }
    
    document.querySelector(".img-modal-close").addEventListener("click", () => {
      document.getElementById("img-modal").style.display = "none";
    });

    document.getElementById("img-modal").addEventListener("click", (e) => {
      if (e.target.id === "img-modal") {
        document.getElementById("img-modal").style.display = "none";
      }
    });

	function setActiveTab(name) {
	tabs.forEach(b => b.classList.remove("active"));
	document.querySelector(`[data-tab="${name}"]`).classList.add("active");
	}
	
	tabs.forEach(btn => {
	const tab = btn.getAttribute("data-tab");
	btn.addEventListener("click", async () => {
		setActiveTab(tab);
		content.innerHTML = "<p>Loading...</p>";
	
		if (tab === "anticheat") {
		const view = await loadAntiCheatData();
		content.innerHTML = "";
		content.appendChild(view);
		}
	
		else if (tab === "donate") {
		Promise.all([
			new Promise(res => bridge.get_paypal_log(res)),
			new Promise(res => bridge.get_usdt_log(res)),
			new Promise(res => bridge.get_stripe_log(res))
		]).then(([paypalLog, usdtLog, stripeLog]) => {
			const view = renderDonateTable(paypalLog, usdtLog, stripeLog);
			content.innerHTML = "";
			content.appendChild(view);
		});
		}

        else if (tab === "characters") {
          const view = await loadCharacters();
          content.innerHTML = "";
          content.appendChild(view);
        }

		else {
		content.innerHTML = tabData[tab] || "<p>Unknown section</p>";
		}
	});
	});
	
    function renderDonateTable(paypalLog, usdtLog, stripeLog) {
      const container = document.createElement("div");
      container.innerHTML = `<h2>All Donations</h2>`;
    
      // 🔍 Filters
      const filters = document.createElement("div");
      filters.className = "donate-filters";
      filters.innerHTML = `
        <input id="filter-char" placeholder="Filter by Char..." />
        <select id="filter-method">
          <option value="">All Methods</option>
          <option value="Stripe">Stripe</option>
          <option value="PayPal">PayPal</option>
          <option value="USDT">USDT</option>
        </select>
      `;
    
      const tableWrapper = document.createElement("div");
      tableWrapper.className = "donate-table-container donate-scroll";
    
      const table = document.createElement("table");
      table.className = "donate-table";
      table.innerHTML = `
        <thead>
          <tr>
            <th>Time</th>
            <th>Character</th>
            <th>Amount (€)</th>
            <th>Currency</th>
            <th>Method</th>
          </tr>
        </thead>
        <tbody></tbody>
      `;
    
      const tbody = table.querySelector("tbody");
      const allRows = [];
    
      // 🟡 PayPal
      const paypalLines = paypalLog.split("\n");
      for (let i = 0; i < paypalLines.length - 1; i++) {
        const line1 = paypalLines[i].trim();
        const line2 = paypalLines[i + 1].trim();
    
        if (line1.includes("→ VERIFIED") && line2.includes("custom=")) {
          const dateMatch = line1.match(/^(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2})/);
          const decoded = decodeURIComponent(line2);
          const customMatch = decoded.match(/custom=([^|]+)\|([^|]+)\|(\d+)/);
          const grossMatch = decoded.match(/mc_gross=([\d.]+)/);
    
          if (customMatch && grossMatch) {
            const [_, char, currency, amount] = customMatch;
            const euro = parseFloat(grossMatch[1]).toFixed(2) + "€";
            const date = dateMatch ? dateMatch[1] : "PayPal";
            const display = `${amount} ${currency}`;
            allRows.push([date, char, euro, display, "PayPal"]);
          }
        }
      }
    
      // 🟢 USDT
      usdtLog.split("\n").forEach(line => {
        const match = line.match(/New USDT Payment: ([\d.]+) USDT from (\w+).*txid:/i);
        const date = line.match(/\[(.*?)\]/)?.[1] || "USDT";
        const currencyLine = line.match(/получил (\d+) (\w+)/i); // если есть
        if (match) {
          const [_, usdt, from] = match;
          const amount = `${parseFloat(usdt).toFixed(2)} USDT`;
          const currency = currencyLine ? currencyLine[2] : "GoblinPoint";
          const value = currencyLine ? `${currencyLine[1]} ${currency}` : "-";
          allRows.push([date, from, amount, value, "USDT"]);
        }
      });
    
      // 🔵 Stripe
      stripeLog.split("\n").forEach(line => {
        const match = line.match(/\[(.*?)\] (\w+)\s+\|\s+(\w+)\s+x(\d+)\s+\|\s+€([\d.]+)/);
        if (match) {
          const [_, date, char, currency, amount, eur] = match;
          const value = `${amount} ${currency}`;
          const euro = parseFloat(eur).toFixed(2) + "€";
          allRows.push([date, char, euro, value, "Stripe"]);
        }
      });
    
      // ⬇️ Sort
      allRows.sort((a, b) => new Date(b[0]) - new Date(a[0]));
    
      function applyFilters() {
        const method = filters.querySelector("#filter-method").value.toLowerCase();
        const char = filters.querySelector("#filter-char").value.toLowerCase();
        tbody.innerHTML = "";
    
        allRows.forEach(row => {
          if (
            (!method || row[4].toLowerCase() === method) &&
            (!char || row[1].toLowerCase().includes(char))
          ) {
            const tr = document.createElement("tr");
            row.forEach(col => {
              const td = document.createElement("td");
              td.textContent = col;
              tr.appendChild(td);
            });
            tbody.appendChild(tr);
          }
        });
      }
    
      container.appendChild(filters);
      tableWrapper.appendChild(table);
      container.appendChild(tableWrapper);
    
      setTimeout(() => {
        filters.querySelectorAll("input, select").forEach(el => {
          el.addEventListener("input", applyFilters);
          el.addEventListener("change", applyFilters);
        });
        applyFilters();
      }, 0);
    
      return container;
    }

    document.querySelector('[data-tab="anticheat"]').click();
};
